import Header from "@/components/header"
import Footer from "@/components/footer"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import { Textarea } from "@/components/ui/textarea"
import { Phone, Mail, MapPin, Clock, Users, Truck } from "lucide-react"

export default function ContactPage() {
  const contactInfo = [
    {
      icon: Phone,
      title: "Phone",
      details: "+91 80500 11001",
      description: "Call us for immediate assistance",
    },
    {
      icon: Mail,
      title: "Email",
      details: "support@kadai2manai.com",
      description: "Send us your queries anytime",
    },
    {
      icon: MapPin,
      title: "Location",
      details: "Karur, Tamil Nadu, India",
      description: "Currently serving Karur region",
    },
    {
      icon: Clock,
      title: "Service Hours",
      details: "5:00 AM - 7:00 AM",
      description: "Daily delivery window",
    },
  ]

  const careerPositions = [
    {
      icon: Truck,
      title: "Delivery Person",
      description: "Help deliver fresh produce to homes every morning",
      requirements: ["Valid driving license", "Local area knowledge", "Early morning availability"],
      type: "Full-time",
    },
    {
      icon: Users,
      title: "Area Agents",
      description: "Manage vendor relationships and expand our network",
      requirements: ["Communication skills", "Local network", "Business development experience"],
      type: "Full-time",
    },
  ]

  return (
    <div className="min-h-screen bg-background">
      <Header />

      {/* Hero Section */}
      <section className="relative py-20 bg-gradient-to-br from-primary/5 via-background to-secondary/5">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-4xl mx-auto text-center space-y-8">
            <Badge className="bg-secondary/10 text-secondary border-secondary/20">Get in Touch</Badge>
            <h1 className="text-4xl md:text-5xl font-bold text-balance">Contact Kadai2Manai</h1>
            <p className="text-xl text-muted-foreground text-pretty">
              Have questions about our service? Want to join our team? We'd love to hear from you.
            </p>
          </div>
        </div>
      </section>

      {/* Contact Information */}
      <section className="py-20">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 mb-16">
            {contactInfo.map((info, index) => (
              <Card key={index} className="hover-lift text-center">
                <CardContent className="p-8 space-y-4">
                  <div className="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center mx-auto">
                    <info.icon className="h-8 w-8 text-primary" />
                  </div>
                  <div className="space-y-2">
                    <h3 className="text-lg font-semibold">{info.title}</h3>
                    <p className="text-foreground font-medium">{info.details}</p>
                    <p className="text-sm text-muted-foreground">{info.description}</p>
                  </div>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Contact Form & Map */}
      <section className="py-20 bg-muted/30">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-16">
            {/* Contact Form */}
            <div className="space-y-8">
              <div className="space-y-4">
                <h2 className="text-3xl md:text-4xl font-bold">Get in Touch</h2>
                <p className="text-xl text-muted-foreground">
                  Send us a message and we'll respond as soon as possible.
                </p>
              </div>

              <Card className="hover-lift">
                <CardContent className="p-8">
                  <form className="space-y-6">
                    <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                      <div className="space-y-2">
                        <label htmlFor="firstName" className="text-sm font-medium">
                          First Name
                        </label>
                        <Input id="firstName" placeholder="Enter your first name" />
                      </div>
                      <div className="space-y-2">
                        <label htmlFor="lastName" className="text-sm font-medium">
                          Last Name
                        </label>
                        <Input id="lastName" placeholder="Enter your last name" />
                      </div>
                    </div>

                    <div className="space-y-2">
                      <label htmlFor="email" className="text-sm font-medium">
                        Email
                      </label>
                      <Input id="email" type="email" placeholder="Enter your email" />
                    </div>

                    <div className="space-y-2">
                      <label htmlFor="phone" className="text-sm font-medium">
                        Phone Number
                      </label>
                      <Input id="phone" type="tel" placeholder="Enter your phone number" />
                    </div>

                    <div className="space-y-2">
                      <label htmlFor="subject" className="text-sm font-medium">
                        Subject
                      </label>
                      <Input id="subject" placeholder="What is this regarding?" />
                    </div>

                    <div className="space-y-2">
                      <label htmlFor="message" className="text-sm font-medium">
                        Message
                      </label>
                      <Textarea id="message" placeholder="Tell us more about your inquiry..." rows={5} />
                    </div>

                    <Button className="w-full bg-primary hover:bg-primary/90 text-primary-foreground">
                      Send Message
                    </Button>
                  </form>
                </CardContent>
              </Card>
            </div>

            {/* Map */}
            <div className="space-y-8">
              <div className="space-y-4">
                <h2 className="text-3xl md:text-4xl font-bold">Find Us on the Map</h2>
                <p className="text-xl text-muted-foreground">
                  We're proudly serving the Karur region with plans to expand across Tamil Nadu.
                </p>
              </div>

              <Card className="hover-lift overflow-hidden">
                <div className="h-96 bg-muted/50 flex items-center justify-center">
                  <div className="text-center space-y-4">
                    <MapPin className="h-16 w-16 text-primary mx-auto" />
                    <div>
                      <h3 className="text-xl font-semibold">Karur, Tamil Nadu</h3>
                      <p className="text-muted-foreground">Interactive map coming soon</p>
                    </div>
                  </div>
                </div>
              </Card>

              <div className="bg-card/50 backdrop-blur rounded-lg p-6 space-y-4">
                <h3 className="text-lg font-semibold">Service Area</h3>
                <p className="text-muted-foreground">
                  Currently delivering fresh produce across Karur city and surrounding areas. Contact us to check if we
                  deliver to your location.
                </p>
                <Button variant="outline" className="w-full bg-transparent">
                  Check Service Availability
                </Button>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Careers Section */}
      <section className="py-20">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center space-y-4 mb-16">
            <Badge className="bg-secondary/10 text-secondary border-secondary/20">Join Our Team</Badge>
            <h2 className="text-3xl md:text-4xl font-bold text-balance">Careers at Kadai2Manai</h2>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto text-pretty">
              Looking for opportunities? Become a part of Kadai2Manai and help us revolutionize fresh produce delivery
              in Tamil Nadu.
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-8 max-w-4xl mx-auto">
            {careerPositions.map((position, index) => (
              <Card key={index} className="hover-lift">
                <CardHeader>
                  <div className="flex items-center space-x-4">
                    <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center">
                      <position.icon className="h-6 w-6 text-primary" />
                    </div>
                    <div>
                      <CardTitle className="text-xl">{position.title}</CardTitle>
                      <Badge variant="outline">{position.type}</Badge>
                    </div>
                  </div>
                </CardHeader>
                <CardContent className="space-y-4">
                  <p className="text-muted-foreground">{position.description}</p>

                  <div className="space-y-2">
                    <h4 className="font-semibold">Requirements:</h4>
                    <ul className="space-y-1">
                      {position.requirements.map((req, reqIndex) => (
                        <li key={reqIndex} className="text-sm text-muted-foreground flex items-center space-x-2">
                          <div className="w-1.5 h-1.5 bg-secondary rounded-full"></div>
                          <span>{req}</span>
                        </li>
                      ))}
                    </ul>
                  </div>

                  <Button className="w-full bg-secondary hover:bg-secondary/90 text-secondary-foreground">
                    Apply Now
                  </Button>
                </CardContent>
              </Card>
            ))}
          </div>

          <div className="text-center mt-12">
            <p className="text-muted-foreground mb-4">
              Don't see a position that fits? We're always looking for talented individuals.
            </p>
            <Button variant="outline" size="lg">
              Send Us Your Resume
            </Button>
          </div>
        </div>
      </section>

      {/* FAQ Section */}
      <section className="py-20 bg-gradient-to-br from-primary/5 to-secondary/5">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-3xl mx-auto">
            <div className="text-center space-y-4 mb-16">
              <h2 className="text-3xl md:text-4xl font-bold">Frequently Asked Questions</h2>
              <p className="text-xl text-muted-foreground">Quick answers to common questions about our service</p>
            </div>

            <div className="space-y-6">
              {[
                {
                  question: "What time do you deliver?",
                  answer: "We deliver fresh produce every morning before 6:30 AM to ensure maximum freshness.",
                },
                {
                  question: "Do I need to pay online?",
                  answer: "No, we offer 100% cash on delivery. You only pay when you receive your fresh produce.",
                },
                {
                  question: "How do I place an order?",
                  answer: "You can place orders through our mobile app or by contacting your local vendor directly.",
                },
                {
                  question: "What areas do you serve?",
                  answer:
                    "Currently, we serve Karur city and surrounding areas. Contact us to check availability in your location.",
                },
              ].map((faq, index) => (
                <Card key={index} className="hover-lift">
                  <CardContent className="p-6">
                    <h3 className="text-lg font-semibold mb-2">{faq.question}</h3>
                    <p className="text-muted-foreground">{faq.answer}</p>
                  </CardContent>
                </Card>
              ))}
            </div>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  )
}
