import Header from "@/components/header"
import Footer from "@/components/footer"
import { Card, CardContent, CardHeader } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Button } from "@/components/ui/button"
import { Calendar, Clock, User, ArrowRight } from "lucide-react"

export default function BlogPage() {
  const blogPosts = [
    {
      id: 1,
      title: "Why Morning-Fresh Vegetables Are Healthier",
      excerpt:
        "Discover the nutritional benefits of consuming vegetables that are harvested and delivered fresh in the early morning hours.",
      author: "Dr. Priya Sharma",
      date: "2025-01-15",
      readTime: "5 min read",
      category: "Health & Nutrition",
      image: "/placeholder-kl1on.png",
    },
    {
      id: 2,
      title: "Top Seasonal Vegetables in Karur You Should Try",
      excerpt:
        "Explore the best seasonal vegetables available in Karur and learn how to incorporate them into your daily meals.",
      author: "Chef Rajesh Kumar",
      date: "2025-01-12",
      readTime: "7 min read",
      category: "Seasonal Produce",
      image: "/placeholder-07t09.png",
    },
    {
      id: 3,
      title: "The Journey of Kadai2Manai – From Farm to Your Home",
      excerpt:
        "Follow the complete journey of how fresh produce travels from local farms to your doorstep through our innovative delivery system.",
      author: "Mr. Manoharan",
      date: "2025-01-10",
      readTime: "6 min read",
      category: "Company Story",
      image: "/placeholder-qa5b6.png",
    },
    {
      id: 4,
      title: "Supporting Local Farmers: The Kadai2Manai Impact",
      excerpt:
        "Learn how our platform is making a positive difference in the lives of local farmers and vendors in the Karur region.",
      author: "Social Impact Team",
      date: "2025-01-08",
      readTime: "4 min read",
      category: "Community Impact",
      image: "/placeholder-dzzqj.png",
    },
    {
      id: 5,
      title: "10 Easy Recipes with Fresh Vegetables",
      excerpt:
        "Quick and delicious recipes you can make with the fresh vegetables delivered by Kadai2Manai every morning.",
      author: "Chef Meera Devi",
      date: "2025-01-05",
      readTime: "8 min read",
      category: "Recipes",
      image: "/placeholder-dirlw.png",
    },
    {
      id: 6,
      title: "How Technology is Revolutionizing Fresh Produce Delivery",
      excerpt:
        "Discover the innovative technology behind Kadai2Manai that ensures efficient and reliable delivery of fresh produce.",
      author: "Tech Team",
      date: "2025-01-03",
      readTime: "6 min read",
      category: "Technology",
      image: "/placeholder-yv9kl.png",
    },
  ]

  const categories = [
    "All",
    "Health & Nutrition",
    "Seasonal Produce",
    "Company Story",
    "Community Impact",
    "Recipes",
    "Technology",
  ]

  return (
    <div className="min-h-screen bg-background">
      <Header />

      {/* Hero Section */}
      <section className="relative py-20 bg-gradient-to-br from-primary/5 via-background to-secondary/5">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-4xl mx-auto text-center space-y-8">
            <Badge className="bg-secondary/10 text-secondary border-secondary/20">Fresh Tips & Stories</Badge>
            <h1 className="text-4xl md:text-5xl font-bold text-balance">Farm-to-Home Blogs by Kadai2Manai</h1>
            <p className="text-xl text-muted-foreground text-pretty">
              Stay informed with articles about healthy eating, fresh produce, local vendor stories, and seasonal
              recipes from our community of experts.
            </p>
          </div>
        </div>
      </section>

      {/* Categories Filter */}
      <section className="py-8 border-b border-border">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="flex flex-wrap gap-2 justify-center">
            {categories.map((category) => (
              <Button
                key={category}
                variant={category === "All" ? "default" : "outline"}
                size="sm"
                className={category === "All" ? "bg-primary hover:bg-primary/90" : "hover:bg-muted"}
              >
                {category}
              </Button>
            ))}
          </div>
        </div>
      </section>

      {/* Featured Post */}
      <section className="py-16">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-6xl mx-auto">
            <div className="text-center mb-12">
              <h2 className="text-3xl font-bold mb-4">Featured Article</h2>
            </div>

            <Card className="hover-lift overflow-hidden">
              <div className="grid grid-cols-1 lg:grid-cols-2">
                <div className="relative h-64 lg:h-auto">
                  <img
                    src={blogPosts[0].image || "/placeholder.svg"}
                    alt={blogPosts[0].title}
                    className="w-full h-full object-cover"
                  />
                  <div className="absolute top-4 left-4">
                    <Badge className="bg-secondary text-secondary-foreground">{blogPosts[0].category}</Badge>
                  </div>
                </div>
                <CardContent className="p-8 flex flex-col justify-center">
                  <div className="space-y-4">
                    <h3 className="text-2xl md:text-3xl font-bold text-balance">{blogPosts[0].title}</h3>
                    <p className="text-muted-foreground text-lg">{blogPosts[0].excerpt}</p>
                    <div className="flex items-center space-x-4 text-sm text-muted-foreground">
                      <div className="flex items-center space-x-1">
                        <User className="h-4 w-4" />
                        <span>{blogPosts[0].author}</span>
                      </div>
                      <div className="flex items-center space-x-1">
                        <Calendar className="h-4 w-4" />
                        <span>{new Date(blogPosts[0].date).toLocaleDateString()}</span>
                      </div>
                      <div className="flex items-center space-x-1">
                        <Clock className="h-4 w-4" />
                        <span>{blogPosts[0].readTime}</span>
                      </div>
                    </div>
                    <Button className="bg-primary hover:bg-primary/90 text-primary-foreground w-fit">
                      Read Full Article
                      <ArrowRight className="ml-2 h-4 w-4" />
                    </Button>
                  </div>
                </CardContent>
              </div>
            </Card>
          </div>
        </div>
      </section>

      {/* Blog Grid */}
      <section className="py-16 bg-muted/30">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold mb-4">Latest Articles</h2>
            <p className="text-muted-foreground">
              Discover more insights about fresh produce, healthy living, and our community
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {blogPosts.slice(1).map((post) => (
              <Card key={post.id} className="hover-lift overflow-hidden">
                <div className="relative">
                  <img src={post.image || "/placeholder.svg"} alt={post.title} className="w-full h-48 object-cover" />
                  <div className="absolute top-4 left-4">
                    <Badge className="bg-secondary/90 text-secondary-foreground">{post.category}</Badge>
                  </div>
                </div>
                <CardHeader>
                  <h3 className="text-xl font-semibold text-balance line-clamp-2">{post.title}</h3>
                </CardHeader>
                <CardContent className="space-y-4">
                  <p className="text-muted-foreground line-clamp-3">{post.excerpt}</p>
                  <div className="flex items-center justify-between text-sm text-muted-foreground">
                    <div className="flex items-center space-x-1">
                      <User className="h-4 w-4" />
                      <span>{post.author}</span>
                    </div>
                    <div className="flex items-center space-x-1">
                      <Clock className="h-4 w-4" />
                      <span>{post.readTime}</span>
                    </div>
                  </div>
                  <div className="flex items-center justify-between">
                    <span className="text-sm text-muted-foreground">{new Date(post.date).toLocaleDateString()}</span>
                    <Button variant="outline" size="sm">
                      Read More
                      <ArrowRight className="ml-2 h-4 w-4" />
                    </Button>
                  </div>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>
      </section>

      {/* Newsletter Signup */}
      <section className="py-20 bg-gradient-to-r from-primary to-secondary">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-2xl mx-auto text-center space-y-8">
            <h2 className="text-3xl md:text-4xl font-bold text-primary-foreground text-balance">
              Stay Updated with Fresh Content
            </h2>
            <p className="text-xl text-primary-foreground/90 text-pretty">
              Subscribe to our newsletter for the latest articles, seasonal tips, and exclusive recipes
            </p>
            <div className="flex flex-col sm:flex-row gap-4 max-w-md mx-auto">
              <input
                type="email"
                placeholder="Enter your email"
                className="flex-1 px-4 py-3 rounded-lg border border-primary-foreground/20 bg-primary-foreground/10 text-primary-foreground placeholder:text-primary-foreground/60 focus:outline-none focus:ring-2 focus:ring-primary-foreground/50"
              />
              <Button className="bg-background text-foreground hover:bg-background/90">Subscribe</Button>
            </div>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  )
}
